package org.msh.etbm.services.mobile.sync;

import org.jboss.seam.Component;
import org.msh.etbm.services.mobile.SyncDataConsumer;
import org.msh.etbm.services.mobile.model.FollowupData;
import org.msh.tb.entities.*;
import org.msh.utils.ObjectUtils;

import javax.persistence.EntityManager;


/**
 * Created by rmemoria on 13/9/17.
 */
public abstract class SyncDataConsumerImpl<E, R> implements SyncDataConsumer<E, R> {

    private EntityManager entityManager;

    EntityManager getEntityManager() {
        if (entityManager == null) {
            entityManager = (EntityManager) Component.getInstance("entityManager");
        }

        return entityManager;
    }

    protected <K> K recoverEntity(Class K, Integer id) {
        if (id == null) {
            return (K)ObjectUtils.newInstance(K);
        }

        return (K)getEntityManager().find(K, id);
    }


    protected void moveLaboratoryExamData(FollowupData data, LaboratoryExam exam) {
        if (exam.getId() == null) {
            TbCase tbcase = getEntityManager().find(TbCase.class, data.getCaseId());
            exam.setTbcase(tbcase);
        }

        exam.setDateCollected(data.getDate());
    }

    /**
     * Return an instance of {@link FieldValue} by its ID
     * @param id the field value ID
     * @return instance of {@link FieldValue}
     */
    protected FieldValue getFieldValue(Integer id) {
        return id == null ? null :
                getEntityManager().find(FieldValue.class, id);
    }

    /**
     * Return an instance of {@link Laboratory} by its ID
     * @param id the field value ID
     * @return instance of {@link Laboratory}
     */
    protected Laboratory getLaboratory(Integer id) {
        return id == null ? null :
                getEntityManager().find(Laboratory.class, id);
    }

    /**
     * Return an instance of {@link Substance} by its ID
     * @param id the field value ID
     * @return instance of {@link Substance}
     */
    protected Substance getSubstance(Integer id) {
        return id == null ? null :
                getEntityManager().find(Substance.class, id);
    }

    protected FieldValueComponent getFieldValueComponent(Integer id) {
        return id == null ? new FieldValueComponent() :
                new FieldValueComponent(getFieldValue(id));
    }

    protected void copyCommonProperties(Object source, Object dest) {
        ObjectUtils.copyObject(source, dest);
    }
}
